% A Beginner's Guide to Map Packs

## Introduction

If you are like me, you find yourself playing the Tactical Battles game for hours on end and enjoying all the map packs that are available from every genre imaginable. Then suddenly, you realize that this might be the perfect outlet for your own creative energies. Whether it is historical campaigns like reenacting the Battle of Bull Run from the American Civil War, adventures filled with iconic fantasy characters or even a post-apocalyptic world featuring mutants and road warriors, you begin to realize that you can make it come to life using the incredible customization made possible through Tactical Battles.

Then again, if you are anything like me, you opened the map creation guide for the game, read through it...and suddenly realized something: this isn't going to be as easy as you thought. There is brand new lingo (like parser and flags). There are long lists of strange words and numbers that apparently do things, but you don't know what. Then there are various objects with cryptic names that seem to make sense, but turn out to be something other than what you thought. Let's face it: when you're a newbie trying to learn this kind of stuff, it can be intimidating. Anyone who has never created anything through computer lingo would feel compelled to turn away in frustration and disappointment.

That is what I felt, what I went through. You're not alone; it happens to everyone in the beginning. I am not particularly intelligent, nor do I really even grasp everything in the map creation guide, despite what it may seem. I still make basic mistakes, and I have had to trash entire map packs because I made fundamental fumbles with all sorts of things. For a while I felt like some crazy mad scientist, trying to make inanimate matter come to life. But I found that this is what it takes: a creative vision, a determined will to make it all work, and just a little help from some friends in the Tactical Battles community.

Before you go any further, I recommend that you copy the Getting Started maps by Ian Reed in order to follow the step-by-step instructions listed in the game user guide. With these maps, you will be able to try out some of the tips and tricks (listed later in this document), which will help you understand the basic concepts of how all this stuff works together.  

To help you out, I will become your virtual Igor. I intend to show you that creating your own map packs is not only possible, but also that the act of creation itself can be just as much fun as playing the game!

So now, if you are ready, go ahead and roll back your sleeves, laugh like an evil mad genius, and bring your creative vision to life!

## Anatomy of a Map Pack File

## What's in a Name?

Each map pack folder is just filled to the brim with text files. They are all over the place, seemingly breeding like Tribbles, filling every nook and cranny. How do you make sense of all of these files?

Well, we do it the same way we do with everything else in our lives. We name them.

This may seem like common sense, but it's important to realize that the name of a file (the first line in the file descriptions as detailed in the Tactical Battle Game map creation Guide) is not just for laughs. These tell the computer what the file is, how to use it, and what order that file will be looked at, compared to other files. Always remember to label your files with the appropriate name!

## What the Heck is a Parser?
 
Glad you asked! A parser is a term that pretty much means the same as format.  No, not like formatting your hard drive, but rather, like the formatting of a document. 

If you ever had to write a report for school, the teacher would most likely provide you with a format to follow so that everyone's report would be the same in structure. If you ever listened to a movie being described, you probably noticed that each movie follows the same format of presentation in the beginning; first, the movie company, then the production company, and lastly, the beginning credits. 

Every time you write, you follow the format of your language. English is read from left to right, Hebrew is read from right to left, and traditional Japanese was read from top to bottom in columns going from right to left!

This is the same for the Tactical Battles program. Until the program is told which format to use, it is more or less blind and unable to read the file correctly. When the format has been established, you can expect everything you wrote down to be followed as you require it.

To show an example of what I mean, try doing this in the Getting Started unit's folder.
* Go to the warrior.
* With the file opened, you will notice that the first line is "Unit". The second line reads, "2 // Parser Version" (don't worry about the slashes; we will get to those a bit later). As you can see, the format of the file follows the guide's outline. After the parser version is the description line of the unit. The skills are on the next line and finally, the flags are listed downward, one per line. 
* Now go to the parser version, erase the number 2 and change it to number 1. Then run the Tactical Battles program, play the Getting Started maps. Select "Simple Fight" and see what happens. 

You will start to get all types of weird errors. You might notice that the program is telling you that your skills are not flags, and other similar error messages. This is because the format of the file was not following the parser version expected.

In the past, the unit files had Parser Version 1, which followed a different format. In fact, the skills and flag lines were reversed compared to where they are now, and an extra line for the name of the file was in place above the description line. 

It is always best to try to keep the parser versions up to date, so that your files can take advantage of any new improvements that continuously occur. However, it is not essential to get it done immediately; many times the parser version will not be changed. In addition, the game creator always makes sure to alert everyone if a parser version gets changed (and what the new format will be).

It is time to go and change the warrior's parser version back to the number 2. When you run the program again, you will notice that the computer is all happy once again without any errors. Make sure you do this, before you go any further. It's OK, I'm a document, I can wait...got it done? Great! Let's continue.

## Whose Line is it Anyway?

Lines are incredibly important in a map pack file. Without everything in its appropriate line, the program will bring forth all sorts of errors or even crash the game!

Yet what does it mean to have a line, or to put things in the line? 

The easiest definition is that a line of code in the file is unbroken by a return carriage. In other words, you cannot hit the enter/return button until you are sure all the data for that specific line is complete. This may seem strange, but this is following the format. Just like it is important for a train to stay on its tracks, it is important to keep everything specific for that line, on that line, alone. While flags seem to break this convention, they actually do not. Still, we will get to that later.

Now, if you have an older version of Jaws and Win OS, you might find yourself having a hard time editing long text or long lists of skills. This usually means that the line you are writing on has extended beyond the size of the window. Sometimes it helps to maximize the window (go to the toolbar of Notepad (or other similar text file editor) and find the maximize option in the system heading. If it is unavailable, your screen is already maximized. Otherwise, hit that option and hopefully that will help you get a few more sentences or words in that line. If you're using Jaws on Windows XP, the keyboard shortcut is Alt, then spacebar, then the X button.

I have been told that other screen readers (like NVDA) might handle working with Notepad and extra long lines more easily. Also, there might be other text file editors available that could do a better job. You can find all of that cool stuff either in the Tactical Battles Game User Guide or by searching the net using your favorite search engine.

Now, flags do not need to be all on a single line. Sometimes a unit or structure's list of flags can get really large, so the format of the files allows you to place one flag per line, one under the other. This is most helpful, and allows you to easily search through your flags to find which one has been misbehaving and crashing your map! While this does seem to break the rule of lines, you must still make sure to keep the flags in either a straight line of data, or it all has to be one after the other, line under line. Either way is valid, but you can't do both in the same file.  

It is important to remember to keep all flags and skills separated by a space, but within a flag or skill, there can be no spaces. In place of  spaces between words within a skill or flag, you must use the    underline. If there is a list of things a flag handles such for terrain limits, the list of terrain would be separated by a comma, but no spaces in between the commas and flags/skills. Everything must touch so to speak. This is one of those things that it takes a little effort  to get used to, but eventually you will be throwing underlines in between words without even thinking about it.

 
## Double Slashes

Perhaps you are thinking to yourself, what is the deal with the double slashes?

Simply, the double slash is a little bit of computer code that is used on a line to stop everything after it from being read by the program. It quite literally slams the door in the face of the computer so that it is clueless about what goes on behind those slashes!
The double slash is a very nice tool to have when you write data down in your files.
The slash marks can:
* Allow you to label a line, to remind you what that line holds. I am sure you noticed the // Parser Version and // Skills all over the place. 

* Help you explain the function of flags. A good example of this is in the Items and Equipment map pack. Go to it and look in the items folder for the longbow. Ian does a good job of explaining exactly what the flags are doing, and all of it behind the double slash marks. 

* Be used to "turn off flags to troubleshoot your map. With a simple double slash in front, you can cause the program to totally ignore a flag (as long as they are on separate lines).  

* Be used to help you determine if your particular line of information is finished. I usually do this for skills and for anything involving text that is read out loud to the player. It helps me find the endings of the lines and if I have to cut and paste, having those will also let me know I don't need to go any further.

## The Introduction to Your Genius

While all map pack files have a description line, the map file is the only one that has three separate lines just for text to be read to the player.

The first line of text is perhaps the most important. It is the introduction. The first thing you might realize is that you have a lot to tell a player when a map starts, but little room to tell them. There is a tip/trick for this in the Tips and Trick part of the document labeled "The Perfect Introduction". Check that out after reading and give it a try.

Normally all good introductions possess these three elements: 
* Description
* Information
* Direction
If you remember these three things when writing up your intro to a map, you will do your players a world of good.

Let's take a look at a Getting Started map introduction.  This one comes from the map titled "Ambush":

"Your party has been ambushed!
  There are 4 boars to the north and 4 wolves to the south.
  Fight carefully to keep everyone alive!"

This one map intro has all the elements that should be present in a map file introduction. 
First is the description: quite simply, you are being ambushed. 
Second, the information: there are boars and wolves to the north and south of your units.
Thirdly, the direction: fight to keep your party members alive.

Sometimes it is important to give locations as well as information. This can be represented by labeling the tile spaces by their coordinates. You can also refer to locations in general terms, such as the eight cardinal directions of a map compass.

## Describing the Description

We aren't quite done with text yet. Now we have to describe the descriptions in your map pack files.
All map pack files feature a descriptive line. The description can simply be the name of the file, or it can be a detailed sketch full of intense particularization. After all, while a unit, structure or terrain might need to describe what it looks or sounds like, things like skills, points and effects are described in a very different way.

Generally speaking, if you have an interesting unit, you can describe either its appearance or its classification. An example for warrior might be either of these:

"An intensely big, heavily armed man stands before you.

Or it could read like this.

"A warrior is a person dedicated to the art of melee and ranged combat."

Either way is acceptable, and it is up to you to describe it as you wish. Sometimes players will want that description, and some don't bother, but in this lab assistant's humble opinion, it is always better to be more descriptive rather than less. 

Skills are a little different. While a description is good, many players want to see what they need, namely, the game mechanics of the skill. It is also acceptable to put some of that information into the User Guide for your map pack, if you feel it isn't going to be needed from the skill description every time the player wants to use the skill itself.

Some of the things you want to consider putting into a skill description are:
* A small description of what the spell does
* How much the skill does in damage
* The range of the skill 
* The cost to use the skill
* Any special effects that the skill performs
* The hot key for the skill (if there is one)

There is no map pack police to answer to, so don't worry if your skill descriptions are not following the guidelines. Not all skills need to be overly descriptive. It is entirely up to you. 

As an example of a good description for a skill, let us take a look at the spell Blaze in the Getting Started maps skills folder.

In the skill description line, it reads the following:

Causes the target square to blaze with a wall of fire for 5 of your turns, any character who occupies a blaze square at the end of their turn or when cast will take 4 damage, Blaze does not stack, Range 3, Costs 2 manna

As you can hear, Ian described the spell, what it does, what its range and damage is, the cost and the special effects of the skill. This is considered a solid description for a skill.

## Skills Are What You Do

So what are skills? Exactly as the heading says. The skill allows the unit or structure to interact with other units and structures. They can affect terrain, handle and manipulate items, or even play a sound file.
 
Skills can use points, but are not points in and of themselves. This distinction will be further defined later in the Skills section of the Anatomy of a Map Pack Folder portion of this document.

Only units and structures have skills. Skills, unlike flags, are created by you. That means you can call them what you want and put them into the skill line of a file wherever you want. They work the same for all units and structures that are in possession of them. This means an attack skill is the same for all units, unless you make a separate attack skill that does different damage, or has a different range. Then, you would have to give that new skill to whatever unit you want it used by. 

For example, you can make a longbow skill and put it into an Elf unit's skill line in their unit file. But, if you do not want the dwarf to use a longbow, simply keep it out. If you want a human ranger unit to have a longbow, you just write it into the skill line of the human ranger's unit file and there it is. Simple as pie.

## Flags Are How You Do It

In essence, where a skill is the arms and legs of your units, the flags are the inner muscle and bone. These incredibly important words and numbers (some of which are arranged like math equations), unleash the powerful abilities of the skills a unit possesses.

If the word "flag seems confusing to you, then perhaps a better word to use would be an "attribute".
For instance, if you have ever played a table top Role Playing Game, or even some of the more popular role playing computer games available, you will see that each character has a list of attributes that define them. Usually they range from a classification, like wizard, warrior, or cleric. They have hit points, armor classes, and identifying characteristics like race, alignment, and level. Some of them have stats that are also what would be considered flags; things like strength, dexterity, wisdom, and charisma. Even things like height and weight would be considered a flag in Tactical Battles. They are pieces of the whole picture.

Flags in Tactical battles can act in a variety of ways within the different files, which makes them quite versatile, but also a bit intimidating since there are so many that overlap everywhere. Here is a small list of what flags are capable of doing.

* Determine loyalties
* Container
* Add/Subtract through time
* Add/Subtract through skills
* Define Movement
* Spend
* Enhance/Detract skill power
* Permanence/no interactive skills 
* Attach a sound or a key
* Reference an effect

We will touch on a lot of these in the Anatomy of a Map Pack Folder portion of this document.
 
## Anatomy of a Map Pack Folder

## As of this Date: A basic list

It is currently February 21, 2013 and below is a list of all the files and folders within a map pack as of this date.

## Files (currently 5)

* Map Pack Settings
* User Guide
* Default Map Flags
* Default Unit Flags
* Default Structure Flags
  
## Folders (currently 13) 

* Units
* Terrain
* Teams
*Structures
*Sounds
* Skills
* Regions
* Points
* Music
* Maps
* Items
* Effects
* Damage Types

## The Files

* Map Pack Settings
This text file holds all of the really important stuff, such as: your name, the name of your map pack as it is seen in the menu list of the Tactical Battles Play a Campaign menu list, your contact information if you desire feedback (or like having stalkers), and of course, the music choice you made for your menu list of your map pack.

*User Guide
The User Guide for your map pack is the most essential point of contact between you and your players. It helps them understand your scenarios, and it enables them to feel confident that they are armed with the knowledge that they can, at the very least, refer back to it when needed. Below are a few basic guidelines to remember when making your User Guide. 

* Background/ History of the elements of the campaign 
* All the keystrokes for the skills used by the player
* Unit Descriptions 
* Skill Descriptions
* Special Terrain Descriptions
* Map(s) layout
* Help and Hints
* Easter Eggs
* End Credits, thank yous and other trivia

Most of these are self explanatory; however, there are some that might need a little explaining. 

Easter Eggs are hidden, overt little nods to other works. Sometimes they contain something humorous or interesting that has no real use in the game as a whole. 

For example, in the first Getting Started map, Simple Fight, you will notice that one of the player's units is called Ian. This is an Easter egg. The creator of the game, Ian Reed, put his own name in the map.
 
In the Tomb Robber map, the vampire level has some boss vampires that have names that bear a striking resemblance to some famous vampires in recent pop culture.

In the One Shot Wonder / Zombie House map, the radio in the utility room actually plays some interesting sounds along with snippets of silly, zombie oriented songs.

* Default Map Flags
There are three text files that carry the moniker of "Default".  Default is a condition that exists when no further detail is given. To help explain this further, imagine that you go to the same restaurant every week and ask for the same hamburger with pickles and ketchup every single time. If the waitress recognizes you, she understands that when you order the usual she knows to bring you a hamburger with pickles and ketchup. This would be considered your default choice. Default Map Flags work the same way, kind of like a template.

With the map files, each map requires a certain number of flags in its flag line within the file. 
These are usually dealing with the size of the map board, the music played, the ability to use the fog of war flags (like use_unseen and use_unexplored flags), and of course, flags that control the number of units and  structures allowed on a tile, and if units from different teams can occupy the same tile on the board.

If you feel that the majority of your maps will follow the same basic flags, you can put these flags into the default map flags text file so you will no longer have to write them down for every single map file. Many times, I will simply copy and paste my default map flags file from one map pack to another and just adjust the values since a lot of them are similar.

* Default Unit Flags:
Being familiar with the default map flags file should make this one a breeze, right? Nope, not necessarily. A default map flag is very different than many of the unit flags, plus some are very active within the process of playing a game.

Usually, what goes into the default unit flag file is what applies to all the units in the folder. You can open up the Getting Started map pack and look at the default unit flags file. There you will see two flags which are in most of the map packs available for Tactical Battles.

These are "Actions_max=6"
Actions_start_turn_restore=100"

Huh? What is going on here? The flags seem very different but in reality they are almost acting in collusion. The actions_max=6 flag is a container flag, which holds 6 points, or actions. That is the maximum value it can attain without a flag to ignore the maximum value. The second flag restores up to 100 points to any and all actions flags, which, since the actions_max flag is in the default, means every single unit in the folder. 

OK, let's make this explanation a lot simpler. Imagine you have a room full of bunnies. Now, bunnies are more or less similar. They have the same form, and do pretty much the same things. Now, if the bunnies were all white, but you wanted them to be pink, you would have two options (if you assume the default unit flag could work in the real world).

You could pick up every single individual bunny and paint it pink. Or, you can put the command "All bunnies must be pink" into a real world default unit flags file, and watch as all the bunnies suddenly turn pink at the same time.  

Now you can see the power of this little text file at work. All of your units can be labeled with the same flags that make them work. Actions, movement, manna, even equipment slots will all be translated to each and every unit. 

* Default Structure Flags
So, just as units have a default file, so do structures. Mostly this is because structures and units are nearly identical, so sometimes it's easier to list common properties into the one text file. We will talk about the dichotomy between units and structures a bit later. For now, just realize that these three little text files are immensely powerful within the map pack folder.

 ## The Folders

* Units: Units are the pieces on the game board that the player, players, or computer use in an active fashion, during their turns. These can be anything you want them to be: spaceships, hobbits, dinosaurs, Santa's elves. It is all in your hands to create them, define their skills and flesh them out with descriptions and flags to enable them the power to do what you want them to do. 

One of the biggest things to remember is that there needs to be a balance between all the units that will fight or interact with each other. Without finding that correct balance, the entire map pack could be ruined due to a unit that's too powerful or too weak. 

* Terrain

Terrain is the environment your units move around in, but it does not hold points like a unit can. Terrain performs these basic functions:

* Adds or subtracts points
* Enhances or detracts from skills
* Affects the costs of moving through them
* Provides obstacles that units can hide behind 
* Represents anything from a door that opens and closes, a stationary farm animal, a building, a pit, or even the void of outer space. It can also represent elements like fire, or be used to indicate an escape route

The use of terrain is highly recommended for most maps. Usually it provides bonuses to range or to hit, but it can also be a way to give the player landmarks that allows him to get his bearings. Throw some unusual terrain somewhere, and it starts to become interesting. 

Terrain doesn't have to be just trees and rocks; it can be anything you imagine, just as long as it isn't expected to be active in a map. Most of the time, the terrain has very little interaction, but this is not a hard and fast rule. It usually doesn't do anything until a structure or unit steps on it, after which it typically reacts as a result. It can have an impact on the unit or structure by affecting chances to hit or damage, providing cover from damage, or even causing damage. 

There are ways to change terrain on the board, and even change it more than once through a single effect. One important thing to consider is that your terrain should have sounds. This adds a higher level of quality to the map that your players will appreciate and enjoy.

It is the flags that truly make the terrain useful, especially for terrain that is an obstruction to your sight or an impassable object. I think one of the most important things you could do to help your players is to put the "special" flag into an escape point terrain (unless you want the player to look for it. If it is not a big deal for it to be hidden, then the flag will allow the player to press shift + T and the program will reveal that escape point, allowing the player to formulate their plans on how to get there). 

* Teams
Teams are divided into three major factions. Each is put into their factions through a flag in the unit or structure file. This is important for a number of reasons. First, the computer needs to know who the player is going to use as units or structures. Second, it helps determine which units and structures the computer will use. Lastly, it determines which units and structures are considered neutral and do not have a turn to act (this neutral team is usually reserved for inanimate objects that can be manipulated by the computer or the player, but do not actually have the ability to do things on its own).

In the team files, it is important to remember that each team has to have a list of other teams that it establishes as enemies. It must be dictated which units hold the friendly or enemy flag in the skill file. This ensures that they will use their skills appropriately. 




*Structures:
Structures and units are practically identical twins. They have the same flags, they can do the exact same things, and they are treated almost exactly like units, but they have two major differences.

First, they have a different name. "Structure" is placed on the first line of the structure file. Second, although structures have player/computer cycle-through buttons just like units, structures use a different set of keys to perform this action. 

So what exactly is a structure? Why is it in the list of folders?

Basically, the structure folder and files are there to give you some added classification to the units. Before the structures existed, everything in the game was considered a unit. This meant that when you cycled through the units in the game, you would have to cycle through every single one, even the unimportant ones (inanimate objects like doors, windows, buildings, etc.). It was time consuming to sort through all of the clutter in the list. Consequently, a distinction was made in an attempt to organize these units into their own niche in the map pack folder. Thus, structures were created, which has greatly improved the game overall.

So what can a structure be? Just about anything. Keep in mind that you want to keep the players' interest.  Helping them enjoy the map that you created is part of the entire map creation process. You want people to get to their units quickly and get into the action. Making some unique or neutral structures on your map will do just that.

To further define structures and units, let's take these examples.
One of the things that classifies a structure from a unit is it's use. If a player controlled character has a lot of tactical options within the scope of it's turn, this is generally considered something that should be a unit. If the thing has very little tactical options or only has one job to do, it is generally smart to make it a structure.
So let's compare a jet fighter to a missile. A jet fighter flies, shoots at enemies, can fire guns or rockets, maybe has afterburners, radar or even bombs. A single missile flies, but all it does or can do is fly to a target and explode. That missile is better off being a structure, so the player can cycle thru their units, which they care about, and if they need to see where their  missiles are, then the structure cycle keys will suffice.


* Sounds
Sound effects are a direct link between the player and the gaming environment that you have created for them. A particular sound can add much more realism to a map pack skill or scenario.

Don't be afraid to explore all of the sound effect options that are available to you. On the internet there are plenty of free sound effects from both amateur and professional sound designers and recordists. For your reference, there is a list of websites that sport free and purchasable sound effects further down in this document. In addition, many map makers are more than happy to share their sounds, as long as they are used for the Tactical Battles game.

One of the most common errors made with sound effects is forgetting that sounds are labeled differently than units and structures. All units and structures follow this naming convention: "Unit_cursor.mp3" 
Only units and structures use this convention (or format, if you will). If you are wondering why your new unit isn't making a peep, take a look in the sounds folder and make sure the _cursor is after the name of the unit or structure.

I am sure you have seen that there are a lot of .wav sound files in the sounds folder of the Getting Started map pack sound folder. Just remember that you can also use mp3 files as well. Converting files to mp3 is beneficial for larger map packs that have a substantial number of sounds. The sound quality of a .wav format file can also be improved by converting it to mp3.

There are a number of good sound file format converters out there. I currently use the Gold Wave program, which is highly accessible. I also have a really powerful converter named Switch. The basic program is free, accessible, easy to use, and will convert wav and mp3 files. It can do this individually, by the entire folder, or even just the sounds you select by hitting the context key. Website links are provided in the Resource portion of this document.

* Skills:
We have talked about skills already, but I would like to go over some of the finer points here.

Skills can do a lot of things, but it is important to remember that you must direct that skill, to make it balance with everything else in the map pack. That means skills are highly customizable, but can cause some serious problems if you don't get it right.

One of the biggest errors you can commit is to avoid creating a skill and then giving it to a computer controlled unit. That skill has no limiting point, which makes your computer go into an infinite loop. This is a very real thing. If you find yourself in that predicament and if you are using Windows XP, you can hit Control+Alt+Delete. This will bring up the task manager; from there, you can try to end the program.

Skills almost always have one of three defining flags: the ability to be casted onto friends, enemies or tiles (spaces). This is not essential, but you will find that it helps your players immensely if they accidently target a friendly and hit the spacebar. 

Tiles, on the other hand, are unbiased. A tile will affect any unit or structure, no matter which team cast it. For most skills that require movement, I also recommend you use the "tile" flag and not the "empty tile" flag. The empty tile flag has caused some problems in the past, especially for skills that involve moving or summoning. 

* Regions
Regions are the most infrequently used of all the folders in a map pack. In fact, you can have a map pack without a Regions folder in it and never know the difference. This doesn't mean it can't be important. In fact, it can be very useful for helping your players navigate your maps.

What a region does is label a tile with whatever you want. This prevents you from having to create special terrain for every nook and cranny of an area (e.g. dungeon or forest). Create a region file, place the name of the region inside it (according to the parser version of the file, of course), and then you can place that region down on the map using the built in map editor.

Here is an example. Let's say you have the player start in a four way corridor. All of the corridors are the same, with the same walls and floor sounds.  To differentiate them, you can label each corridor with a region titled north, south, east, and west. (As a tip, you have the ability to label them anything you want, but the classic cardinal directions tend to be most useful.) 

These work very well in maps that have similar terrain sounds. If you have a map where you have placed a front and a back yard that is all grass, you could use the regional files to label them front or back yard to help your players.

In the end, it is up to you to determine if you need them, but it is good to remember to look at the game through your players' perspective. You may know all of the nooks and crannies of your map, but your players probably don't. So, consider using regions where they are needed; your players will thank you.



+ Points:
If skills are the limbs of your creation and the flags are the muscle and bone, then points are the very heart of the map pack. Without points, the map pack would simply cease to be.

The Tactical Battles game utilizes points in conjunction with flags to do anything from measuring health,   doing damage, restoring energy, moving units, or even just counting rounds down. The point is both versatile and essential.

The first thing to remember is to declare all of your points. That means you must create a point file, fill it in with the information and flags as detailed in the map creation guide, and stick it into the point's folder. If you do not do this, the game will complain about it and tell you the point is not recognized. 

I like to think of it this way. Imagine you have an alien from planet X, and he wants to know all about your instruments. While he has a good idea about music in general and can play his native instruments, he isn't really familiar with the instruments of our world. So you take him to a room full of earth's most interesting musical instruments and you tell him to go ahead and play the flute. The first thing the alien will do is look at you questioningly, and tell you he has no idea what you're talking about. That is when you must go and find the flute, hand it to him and say, "This is a flute." Now the alien understands, and then starts to play the flute.

It is the same way with points. First you tell the computer how a point should behave, and then it will say, "Oh! OK, I understand now.

The biggest point is the life point. It has a few other names, but it is most commonly referred to as health.  In the health point file, there is a flag called "at zero=death". For your information, this flag is very useful for more than just the death effect. Nevertheless, for right now, this is essential to the types of units/structures that hold a life-force point of some sort. Don't forget this because it will crash the game if you do.

The second thing you want to do with points is establish how many different points the units and structures have in your map pack. This usually means determining how many actions, movements or magical energies the unit has. 
One of the useful flags to use in action and movement point files is the Allows actions" flag, which will allow the player to get a report on all of their units which still have points left to use. This is done when the player uses the A + shift keys. 

The next step is to maintain your points for the units that need to be refreshed every single round. Make sure they are placed in either the unit/structure file, or in the default unit/structure flags files.  Remember that while the units and structures are practically the same thing, they do not cross flags. The default unit flags will only go for units and vice versa with structures.

The very last thing is to determine the balance of the costs of all those points. What does it cost to cast a fireball? How many points of energy does it take to turn an orc purple? All of these details have to be balanced throughout the entire map pack, making sure that all the points are spent, restored, or manipulated the way you want. 

Points are also a great way to keep counts of arrows, ammo, bombs, dilithium crystals, fairy dust, etc. Anything that can be expended and does not replenish in every round is a good thing to consider for balance in the units. 
For example, if you give your elf ranger 100 arrows, the player will not concern himself with having to reload because he has an overabundance of ammunition. On the flip side, if you give the same elf ranger only 2 arrows, then the player is stuck with a supply that is too limited. Finding the right balance between the two is an essential part of all map packs. 

* Music:
Music works very much like sound effects. When you fit the right piece to a particular scenario, it greatly enhances the players' experience. Eerie, sinister tones for dark places like dungeons and cemeteries will immediately put your player on his guard. Light, playful melodies with birds chirping in the background might invoke a mental image of an open field on a sunny day. 

Movies were forever changed with the birth of the soundtrack, and games are absolutely the same way. Sound effects are great, but sometimes you just need that special music that gets your heart pumping. It's tailored to make you feel tense, excited, happy or sad. Think about Star Wars, Indiana Jones, Star Trek, and James Bond...when you hear their music, you are immediately pulled into the creative universe that they exist in. A Tactical Battles map pack can be the same way, if you pair the right sound track with the scenarios you planned out.

In the Resources part of this document, there is a short list of royalty free music available through the internet. Some of it is free; others can be purchased. That is all in your hands.

* Maps:
Maps also hold some very interesting flags in the two bottom lines of the file, just before the placing of objects on the map board itself. The victory and defeat conditions can change a simple war game into a more creative game. I would recommend that if you have several maps you wish to make, that you should consider using some of these conditions, if feasible. 

There is a format issue that you need to remember. For the moment, the victory and defeat conditions always assume the opposing team is in the victory condition line, and that your units will be represented in the defeat condition line. You cannot switch them. So, if your victory condition is the death of one of your own units, you will keep getting errors from the game for this reason. With multiplayer, this little issue might have to change, but for right now, the format is where it is at. 

* Items:
Items are an amazing addition to the Tactical Battles map pack. These can be used in a variety of ways similar to skills, and they allow a whole new dimension to things such as how a unit performs in combat or how a unit works within the logic of the map. 

In the Items and Equipment example map pack, you can see how items can be picked up, dropped, equipped and unequipped. They can also be given to other friendly units or even enemy units if you change the skill flags. 

When it comes to items, the most important thing to remember is the flags:

"Useable_forever"
"useable_once"
"Stackable" 
"Equip slots="
These four flags are for items only. An item file will not work unless one of those has been placed into it. 

When it comes to items and equipment, you can use some shortcuts to filling out every unit/structure with them. You can simply use the equip slots= flag in the default unit flags file so that all the units will possess those same slots. Of course, if you have unique units that don't have those same slots, you can always go to them and simply write equip slots=none. It will show up as none in the equipment sheet, but it will let the player immediately know the unit doesn't have slots. 

Equipment slots can be much more than spaces on a being's body. They can be the elements of a spaceship, the parts of a moving vehicle, or even a giant transforming robot. The slots are completely up to you to make.

Just a reminder: make sure you get the equipment, take item, use item, drop item and give item skills from the items and equipment map pack and put these in your own skills folder. Make sure the skills are properly listed in the appropriate units/structures. Without these skills, you will not be able to use the items at all.

* Effects:
An Effect is almost like Skill's little kid sister. Sometimes they're great, but sometimes they kick you in the shins and run to rat you out to your parents. (Not my kid sister, though. My sister is beautiful and kind and would never do anything like that to me. She took the time to edit my little project here, and didn't even ask for a single cheeseburger in return. She didn't write this paragraph, I swear.)

Understanding the works of effects is like this: imagine you have a match and an open can of gasoline. Lighting the match and throwing it into the gasoline to create a massive explosion would be considered the skill of a unit. The length of time the fire stayed burning, how far the explosion went, and the distance of burning area would be the effect of the skill. 

So basically, effects handle duration, but that isn't all there is to it. There are effects that a skill can summon up with the effects= flag. 

Effects= is actually a skill flag, but it works similar to an at_ zero= flag on a point. Both can activate an effect, and it doesn't have to be death. It can be a regeneration spell, it can enhance sight range on a unit, or it can even toggle the team of a unit by using one of the very handy scripts provided by Craig Brett. 

Of all the folders in a map pack, I find the effects to be a little more difficult to work with, simply because of the subtle differences between effects and skills. I recommend you do a lot of looking through other map pack effects folders to get an idea of the way they work. The Getting Started maps have some of the most iconic effects; I find myself referencing them again and again. 

* Damage Types:
Damage type files are actually very important. The game will crash if you do not have any in the folder, so when building your map pack, make sure you have at least one that has the "Default" flag in the appropriate line of the file.

Just like points, you have to tell the computer the types of damage that can be done. In the Getting Started maps, you will see that the three damage types are physical, magic, and the default.

So what is this all about? Simply put, the units and structures in your map pack might be damaged normally in a physical sense, but then there are types of damage that are diverse enough to make a difference. These types of damage can be protected against or inflicted according to your whim as a map creator. It is not necessary to have more than the one default damage type, but some maps can be extremely intense using the different types of damage. Luckily for the players, they don't have to worry about that. Unfortunately, you do.

One of the biggest issues with damage type is that it must be represented when it needs to be in the infliction and protection flags. Let's say you forget to add it into a piece of armor. The damage type that it was meant to block will now be able to stroll right in and steal all your silverware. So, always make sure to define the damage type if you plan on using it.

Here is an example:

Let's say you have a fantasy campaign where your wizards can use the four elements. You make your mages. Then, according to their particular element of study, they will have a slight protection against that type of element. In the damage type folder, you would want to add the damage types of fire, air, earth and water. These are in addition to the physical damage type file.

Now you want to give the fire elementals 5 points of protection against fire. You can do this a number of ways. The easiest way to do it is to place the protection into a passive skill. A passive skill is a skill with the passive flag, and that means the skill is always in effect when it is needed. Not all flags work in a passive skill, but protection does.

Now you make your skill file. It should look something like this:

Skill
2 // Parser Version
Protects the fire elementalist for five points of fire damage automatically.
Passive
Health_protect=5|fire

Easy, right? It simply states that the fire mage will have five points of damage absorbed" by the protection flag if the attack against the mage is fire based.

That attack skill would look like this:

Skill
2 // Parser Version
Fire strike causes 10 points of fire damage to a target. Range is 3, actions cost is 1, hot key is F.
Enemy
Range=3
Actions_cost=1
Health_inflict=10|fire
Sound=fireball
Key=f

Here we see that a fireball spell does 10 points of fire damage. If this is cast at the fire elementalist you just created, five of that damage is blocked by the fire immunity provided by the passive skill.

Remember, you always need to ensure that all of your attack and protection skills and/or items are covering the damage types that you want covered. If you start noticing that your fire elementalists are taking way too much damage, or his fire magic is getting shortchanged, then review through all those skills/items (and even the effects) to make sure you didn't miss a place to stick the |damage type in.

## Tips and Tricks

## The Perfect Introduction

Here is a trick Ian Reed himself created to help me out with introductions to maps that are way too long to fit on a notepad text file. This will also work in the victory and defeat text lines of the map file.

Don't worry about trying to figure out the code. The only part you want to worry about is the portion that deals with a sound file. It will play either mp3 or wav format. What I do is use a text to speech converter. My scanner program, Open Book, does this, but so does Gold Wave and probably a number of other resources out there in the community. 

To begin, write up your text in the text editor of your choice. Convert it into a sound file. Then, put in the code below featuring the sound file that you made (the sound file needs to be put into the sounds folder, and not the music folder).

So, if your sound file is called "Map5introduction.mp3, you would paste this code into the introduction line of the map file and put the sound file in like this:

@ sound("map5introduction.mp3", { synchronous : true })
 
That's all there is to it! It will play the sound file featuring your extended introduction. Anytime the player is done, or doesn't want to hear the intro again, they can simply hit a key and start playing.

The above is actually a script, and with TB being open for those who know how to program, this is a great way to develop new flags for the tactical battles community!



















## Resources

Below is a list of royalty free websites that provide free sound effects. Some of these sites also make royalty-free sound effects for purchase. 

The Recordist: http://www.therecordist.com/free-sfx

Sound Dogs: http://www.sounddogs.com

Audio Micro: http://www.audiomicro.com

Hollywood Edge: http://www.hollywoodedge.com

Blastwave Studios: http://www.blastwavefx.com

Affordable Audio for Everyone: http://www.affordableaudio4everyone.com

Sound Bible: http://soundbible.com

Shockwave: http://www.shockwave-sound.com/Sound_Effects.html

Star Trek Dimensions: http://www.stdimension.org/MediaLib/overviewe.htm

Voices and Vocal: http://www.pacdv.com/sounds/voices-1.html

Media College: http://www.mediacollege.com

The Force: http://theforce.net/fanfilms/postproduction/soundfx/index.asp

Blastbay Studios: http://www.blastbay.com

Overclocked: http://ocremix.org

Below are some YouTube links that feature great music from many popular games ranging from past to present. 

Choicest VGM: Older Video Game Music
http://www.youtube.com/playlist?list=PL5AE3B07EA5100659

The Music of Video Games Volume 3: older video game music
http://www.youtube.com/playlist?list=PL31E85566E71354FD&feature=plpp

E Guide Dog is a blind accessible software list that has all sorts of programs that let you convert sound files, and other cool things.
http://www.easyfreeware.com/files/eguidedog_free_software_for_the_blind.zip/133799

GoldWave is the sound editing software I use and I think it is really easy to do most of what you need:
http://www.goldwave.com
## GoldWave: A Basic Guide to Sound Editing

GoldWave is a sound editing software program that, when first opening it up, becomes immediately intimidating. There are all sorts of lingo and strange terms that make no sense to anyone but a real professional.

Looks can be deceiving, or so they say. 

GoldWave is remarkably easy to use. In no time flat, you will be able to make tons of interesting sounds and sound effect changes. (Note: I actually purchased the GoldWave program, which opens up some program features.)

I'm not an expert on the program, so for more detailed help, you might want to access the help file. As a last resort, you can always throw yourself on the tender mercies of various blind technology mailing lists or friends.

## Opening a Sound File

In the file heading of the toolbar, there is an open option. Hitting that will allow you to open a sound file in gold wave. My default folder for all my sound file work is located in My Documents, but you can choose wherever you want it to come from. 

Simply type in the name and file extension. After you hit enter, the sound will load. Bigger files (for instance, movie length files) take longer to load and will require more of your patience.

## Playing a Sound

Now that the file is loaded, you can use these different key commands to play the file in a variety of ways.

* Hit the spacebar to toggle the sound file to play or to pause.
* Use the J key to reverse the play of the sound file. It will play backwards at a higher rate of speed. It is really more of a rewind feature to help you choose the exact spot in the file that you want to work on.
* Use the L key to fast forward the file. It will play back rapidly to make everything sound like a Chipmunks Reunion Concert.
* You can hit the F4 key to play the sound, instead of the spacebar.
* You can hit the F5 key to play the file backwards at normal speed. Sometimes this is nice to use if you want to see what a sound is like played backwards.
* You can go to the toolbar and change how fast the J and L keys move through the sound file. I have never done it myself, but it's there for you adventurous types.
* The K key reverts the fast forward or fast reverse back to normal speed and play the file.

## Trimming a sound

If you want to trim a sound (meaning, you want to cut it down to a nice short length, or you want a particular sound out of a longer file), it is really very simple.

Play to the part of the file where you want to start the trimming. When you feel you are in a good place, use the { _left brace). This virtually stays in that location in the file.

Next, play through the file until you reach the point where you want to end the clip. When you feel satisfied hit the } (right brace). 

These braces now have that portion selected. Hit the key combo control + T. That will trim away the clip from behind and ahead of the clip you preserved. Don't worry; the file has not permanently changed. In fact the file is never permanently changed unless you hit the standard Control + S key combo.

So, now you have your clip! All you need to do is save it. Go to the toolbar and select Edit. In the Edit heading is the Copy To option. Select this and write in the file name for the clip. Then choose the file format and the location where it should be saved. Once this is done, the clip is saved and now you can go back to the sound file.

If you want to continue to play through the sound file, you can recover it by going to Edit in the toolbar and click the undo trim option. The sound file will start from where the clip ended. The whole file is still present; that is just where it starts at. 

Once you have finished with the file, be sure to go to the file heading in the toolbar and close the file, or close all if you had more than one sound file loaded into the program. The program will ask if you want to save the changes to the current file; select no for this. Otherwise, your original files will suffer some damage.

## Pasting clips

Pasting clips is really quite easy. If you have two files that you want to paste together (for example, a whoosh sound and an impact sound), you start by loading up one of the sounds. For purposes of this exercise, let's load the impact sound. Once it's loaded, give it a play. Then go to the edit heading and cut the sound. This copies the sound to the clip board of the program.

Now open up the second file you want to paste, which would be the whoosh sound. Once it is loaded, play it just to make sure you have it. Go to the Edit heading in the toolbar and select the option "Paste At". When you open it, you can see that there are three options. Paste it at the beginning, at the finish marker, or at the end. (I am still trying to figure out how to use the finish marker. It doesn't seem to be the same markers that are used for the trim, so I usually use the other two options.) In this case, you loaded the impact first and it is in the clipboard, so you paste it using the end option.

When you first try to play it, the playback will be weird, so just hit space again and it should give you the combination you wanted. While this works for many situations, sometimes this isn't good enough. There is a way to mix sounds at the edges but I am not sure how to do that. If someone knows, I would love to have that info. I will happily put it into the guide with full credits for the input.

Anyway, that is about all there is to pasting a couple of clips together. Sometimes I try to bring the two sounds closer by trimming the space and then deleting that trim part. Sometimes it works, sometimes it doesn't. 

If you don't like the combination you made, or the sounds ended up backwards, don't fret. Just remember that you can undo almost every move you make in the program. If you do like your new creation, go to the edit part of the toolbar, use the select all option, and then the copy clip to option to save it.  Be sure to close your sound files. I always use close all before starting on a new operation. 

## Effects

Oh no! Effects again! This time, all the hard work has been done for you. The effects heading in the toolbar has a multitude of different effects that can be applied to a sound. The effects are a bit heavy with ten dollar words, but don't panic! Just load up a sound and start playing with the effects to get a feel for what they can do and you will feel like a pro after a  little while.

Before I start, I want to tell you about a very handy function that GoldWave has. It is called the preset. Each effect has a number of presets that do a lot of the calculations and sound engineering stuff that no normal sane human being wants to deal with. When you hit enter on one of the effects of the toolbar, you will be taken to another small window. You will be sitting on the preset list. Use the arrow keys to cycle through the different presets that particular major effect performs. Once you land on something good, hit the tab and control key to go up and down the window. When on preview, hit that, and the sound will be played with that particular preset effect added. If you like it, go down to the OK button and that will be added to the sound. Don't panic if you do this on accident; you can undo this if you need to. 

Very important note! You do not want to hit enter or the space bar on the remove preset button. You will not be able to undo this action, and you will have to uninstall and reinstall the entire program all over again to get it back. 

Also, in these small windows, you will find different options and edit boxes as well as scalable numbers and the like. There is a useful help button in the window, right underneath the OK button which will take you to the user guide of the portion you are currently using. It comes in handy, but sometimes it can be too wordy and/or short on details, especially when it comes to visual things that the program is able to do as well.

My suggestion is that you load up a short sound file and just play around with it. I would not recommend altering any of the source files, however. I always make a copy of the file I'm working on, in case I do something stupid.

In conclusion, just remember that you don't have to do this alone. Aside from me, the email list for Tactical Battles is always frequented by helpful individuals who are eager to help any map pack creator in need. I hope this guide has answered some of your questions and helped you to learn the basics. 

And there you have it! We have dug up the parts and tagged them all. We stitched them all together and filled them with music, movement, skills and sounds. All that's left to do is to pull the lever of your own creativity.  So, flip the switch and spark the electricity! Get started with building your very own creation and make it come to life!
